ORIGIN		= Symantec C++
ORIGIN_VER	= Version 6.10
VERSION		= DEBUG

PROJ		= TEST_SC
APPTYPE		= WIN32S EXE
PROJTYPE	= EXE

CC		= SC
MAKE		= MAKE
RC		= RCC
HC		= HC
ASM		= SC
DISASM		= OBJ2ASM
EXE2BIN		= EXE2BIN
LIBR		= IMPLIB
LNK		= LINK386
CVPK		= CVPACK

DLLS		= 

HEADERS		= applib.h apptypes.h char_v.h  \
		grapher.h int_vect.h tplot.h ..\..\bc4\include\windows.h  \
		..\..\sc\include\windows.h 

LIBS		= KERNEL32.LIB GDI32.LIB USER32.LIB

DEFFILE		= TEST_SC.DEF

CFLAGS		=  -cpp -Jm -mn -C -WA -3 -a8 -c -g 
HFLAGS		= $(CFLAGS) 
LFLAGS		=  /CO /LI 
MFLAGS		= MASTERPROJ=$(PROJ) 
RESFLAGS	=  
DEBUGGERFLAGS	=  -LOADSYMBOLS 
IMPLIBFLAGS	=  -IMPLIB -DLL 
CVPKFLAGS	=  
AFLAGS		= $(CFLAGS) 
HELPFLAGS	= 

MODEL		= N

PAR		= PROJS BATS OBJS

DEFINES		= 
RCDEFINES	= 
LIBDIRS		= 
INCLUDES	= 

OBJS		=  applib.OBJ  char_v.OBJ  grapher.OBJ  \
		 int_vect.OBJ  test.OBJ  tplot.OBJ 

RCFILES		=  test.RES 

RESFILES	= 

SYMS		= 

HELPFILES	= 

BATS		=  

.C.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.c

.CPP.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cpp

.CXX.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cxx

.CP.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cp

.H.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$*.sym $*.h

.HPP.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$*.sym $*.hpp

.HXX.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$*.sym $*.hxx

.C.EXP:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -e $*.c -l$*.lst

.CPP.EXP:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -e $*.cpp -l$*.lst

.CXX.EXP:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -e $*.cxx -l$*.lst

.CP.EXP:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -e $*.cp -l$*.lst

.ASM.EXP:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -e $*.asm -l$*.lst

.OBJ.COD:
	$(DISASM) $*.OBJ >$*.cod

.EXE.COD:
	$(DISASM) $*.EXE >$*.cod

.COM.COD:
	$(DISASM) $*.COM >$*.cod

.OBJ.EXE:
	$(LNK) $(LFLAGS) @$(PROJ).LNK

.EXE.COM:
	$(EXE2BIN) $*.EXE $*.COM

.DLL.LIB:
	$(LIBR) $*.LIB $*.DLL

.RTF.HLP:
	$(HC) $(HELPFLAGS) $*.HPJ

.ASM.OBJ:
	$(ASM) $(AFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.asm

.RC.RES: 
	$(RC) $(RCDEFINES) $(RESFLAGS) $(INCLUDES) $*.rc

.DLG.RES:
	echo \#include "windows.h" >$$$*.rc
	echo \#include "$*.h" >>$$$*.rc
	echo \#include "$*.dlg" >>$$$*.rc
	$(RC) $(RCDEFINES) $(RESFLAGS) $$$*.rc
	-del $*.res
	-ren $$$*.res $*.res



all:		$(PROJ).$(PROJTYPE) $(POSTLINK) done

$(PROJ).$(PROJTYPE):	$(PRECOMPILE) $(OBJS) $(RCFILES) $(RESFILES) $(HELPFILES) $(POSTCOMPILE) 
			$(LNK) $(LFLAGS) @$(PROJ).LNK
			$(CVPK) $$SCW$$.$(PROJTYPE) $(CVPKFLAGS)
			-del $(PROJ).$(PROJTYPE)
			-ren $$SCW$$.$(PROJTYPE) $(PROJ).$(PROJTYPE)
			-echo $(PROJ).$(PROJTYPE) built

done:
		-echo $(PROJ).$(PROJTYPE) done

buildall:	clean	all


clean:
		-del $(PROJ).$(PROJTYPE)
		-del SCPH.SYM
		-del applib.OBJ
		-del char_v.OBJ
		-del grapher.OBJ
		-del int_vect.OBJ
		-del test.OBJ
		-del tplot.OBJ
		-del test.RES

cleanres:
		-del test.RES

res:		cleanres $(RCFILES) all


link:
		$(LNK) $(LFLAGS) @$(PROJ).LNK
		$(CVPK) $$SCW$$.$(PROJTYPE) $(CVPKFLAGS)
		-del $(PROJ).$(PROJTYPE)
		-ren $$SCW$$.$(PROJTYPE) $(PROJ).$(PROJTYPE)




include TEST_SC.dep

